-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Dexterity support gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["SupportAddedColdDamage"] = {
	name = "Added Cold Damage",
	color = 2,
	support = true,
	requireSkillTypes = { 1, 10, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 30), 
	},
	qualityMods = {
		mod("ColdDamage", "INC", 0.5), --"cold_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ColdMin", "BASE", nil), --"global_minimum_added_cold_damage"
		[3] = mod("ColdMax", "BASE", nil), --"global_maximum_added_cold_damage"
	},
	levels = {
		[1] = { 8, 4, 6, },
		[2] = { 10, 5, 7, },
		[3] = { 13, 6, 9, },
		[4] = { 17, 8, 11, },
		[5] = { 21, 10, 15, },
		[6] = { 25, 13, 19, },
		[7] = { 29, 16, 24, },
		[8] = { 33, 20, 31, },
		[9] = { 37, 25, 38, },
		[10] = { 40, 30, 45, },
		[11] = { 43, 35, 52, },
		[12] = { 46, 40, 61, },
		[13] = { 49, 47, 70, },
		[14] = { 52, 54, 81, },
		[15] = { 55, 63, 94, },
		[16] = { 58, 72, 108, },
		[17] = { 61, 83, 125, },
		[18] = { 64, 95, 143, },
		[19] = { 67, 109, 164, },
		[20] = { 70, 125, 188, },
		[21] = { 72, 137, 205, },
		[22] = { 74, 149, 224, },
		[23] = { 76, 163, 245, },
		[24] = { 78, 178, 267, },
		[25] = { 80, 194, 291, },
		[26] = { 82, 212, 318, },
		[27] = { 84, 231, 346, },
		[28] = { 86, 251, 377, },
		[29] = { 88, 274, 411, },
		[30] = { 90, 298, 447, },
	},
}
skills["SupportAdditionalAccuracy"] = {
	name = "Additional Accuracy",
	color = 2,
	support = true,
	requireSkillTypes = { 1, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
	},
	qualityMods = {
		mod("Accuracy", "INC", 1, 0, 0, nil), --"accuracy_rating_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Accuracy", "BASE", nil, 0, 0, nil), --"accuracy_rating"
	},
	levels = {
		[1] = { 8, 74, },
		[2] = { 10, 100, },
		[3] = { 13, 127, },
		[4] = { 17, 157, },
		[5] = { 21, 190, },
		[6] = { 25, 230, },
		[7] = { 29, 290, },
		[8] = { 33, 350, },
		[9] = { 37, 400, },
		[10] = { 40, 453, },
		[11] = { 43, 528, },
		[12] = { 46, 586, },
		[13] = { 49, 645, },
		[14] = { 52, 707, },
		[15] = { 55, 772, },
		[16] = { 58, 840, },
		[17] = { 61, 887, },
		[18] = { 64, 934, },
		[19] = { 67, 983, },
		[20] = { 70, 1034, },
		[21] = { 72, 1085, },
		[22] = { 74, 1138, },
		[23] = { 76, 1191, },
		[24] = { 78, 1246, },
		[25] = { 80, 1301, },
		[26] = { 82, 1358, },
		[27] = { 84, 1415, },
		[28] = { 86, 1474, },
		[29] = { 88, 1533, },
		[30] = { 90, 1594, },
	},
}
skills["SupportBlind"] = {
	name = "Blind",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		--"global_chance_to_blind_on_hit_%" = 10
	},
	qualityMods = {
		--"blind_duration_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		--[2] = "blind_duration_+%"
	},
	levels = {
		[1] = { 8, 0, },
		[2] = { 10, 2, },
		[3] = { 13, 4, },
		[4] = { 17, 6, },
		[5] = { 21, 8, },
		[6] = { 25, 10, },
		[7] = { 29, 12, },
		[8] = { 33, 14, },
		[9] = { 37, 16, },
		[10] = { 40, 18, },
		[11] = { 43, 20, },
		[12] = { 46, 22, },
		[13] = { 49, 24, },
		[14] = { 52, 26, },
		[15] = { 55, 28, },
		[16] = { 58, 30, },
		[17] = { 61, 32, },
		[18] = { 64, 34, },
		[19] = { 67, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportBlockReduction"] = {
	name = "Block Chance Reduction",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
	},
	qualityMods = {
		--"global_reduce_enemy_block_%" = 0.25
	},
	levelMods = {
		[1] = nil, 
		--[2] = "global_reduce_enemy_block_%"
		--[3] = "reduce_enemy_dodge_%"
	},
	levels = {
		[1] = { 18, 20, 20, },
		[2] = { 22, 21, 20, },
		[3] = { 26, 21, 21, },
		[4] = { 29, 22, 21, },
		[5] = { 32, 22, 22, },
		[6] = { 35, 23, 22, },
		[7] = { 38, 23, 23, },
		[8] = { 41, 24, 23, },
		[9] = { 44, 24, 24, },
		[10] = { 47, 25, 24, },
		[11] = { 50, 25, 25, },
		[12] = { 53, 26, 25, },
		[13] = { 56, 26, 26, },
		[14] = { 58, 27, 26, },
		[15] = { 60, 27, 27, },
		[16] = { 62, 28, 27, },
		[17] = { 64, 28, 28, },
		[18] = { 66, 29, 28, },
		[19] = { 68, 29, 29, },
		[20] = { 70, 30, 29, },
		[21] = { 72, 30, 30, },
		[22] = { 74, 31, 30, },
		[23] = { 76, 31, 31, },
		[24] = { 78, 32, 31, },
		[25] = { 80, 32, 32, },
		[26] = { 82, 33, 32, },
		[27] = { 84, 33, 33, },
		[28] = { 86, 34, 33, },
		[29] = { 88, 34, 34, },
		[30] = { 90, 35, 34, },
	},
}
skills["SupportCastOnCrit"] = {
	name = "Cast On Critical Strike",
	color = 2,
	support = true,
	requireSkillTypes = { 1, 36, },
	addSkillTypes = { 42, },
	excludeSkillTypes = { 37, 41, 30, 44, 61, },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
		skill("cooldown", 0.5), 
		--"cast_linked_spells_on_attack_crit_%" = 100
		skill("triggered", true, { type = "SkillType", skillType = SkillType.TriggerableSpell }), --"spell_uncastable_if_triggerable" = ?
		skill("showAverage", true, { type = "SkillType", skillType = SkillType.TriggerableSpell }), 
	},
	qualityMods = {
		mod("CritChance", "INC", 1, 0, 0, nil), --"critical_strike_chance_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Spell), --"support_cast_on_crit_spell_damage_+%_final"
	},
	levels = {
		[1] = { 38, 20, },
		[2] = { 40, 21, },
		[3] = { 42, 22, },
		[4] = { 44, 23, },
		[5] = { 46, 24, },
		[6] = { 48, 25, },
		[7] = { 50, 26, },
		[8] = { 52, 27, },
		[9] = { 54, 28, },
		[10] = { 56, 29, },
		[11] = { 58, 30, },
		[12] = { 60, 31, },
		[13] = { 62, 32, },
		[14] = { 64, 33, },
		[15] = { 65, 34, },
		[16] = { 66, 35, },
		[17] = { 67, 36, },
		[18] = { 68, 37, },
		[19] = { 69, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportCastOnDeath"] = {
	name = "Cast on Death",
	color = 2,
	support = true,
	requireSkillTypes = { 36, },
	addSkillTypes = { 42, },
	excludeSkillTypes = { 9, 37, 41, 30, 44, 61, },
	baseMods = {
		--"cast_on_death_%" = 100
		skill("triggered", true, { type = "SkillType", skillType = SkillType.TriggerableSpell }), --"spell_uncastable_if_triggerable" = ?
		--"spell_only_castable_on_death" = ?
		skill("showAverage", true), --"base_skill_show_average_damage_instead_of_dps" = ?
	},
	qualityMods = {
		mod("AreaOfEffect", "INC", 3), --"area_of_effect_+%_while_dead" = 3
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil), --"cast_on_death_damage_+%_final_while_dead"
	},
	levels = {
		[1] = { 38, 0, },
		[2] = { 40, 16, },
		[3] = { 42, 32, },
		[4] = { 44, 48, },
		[5] = { 46, 64, },
		[6] = { 48, 80, },
		[7] = { 50, 96, },
		[8] = { 52, 112, },
		[9] = { 54, 128, },
		[10] = { 56, 144, },
		[11] = { 58, 160, },
		[12] = { 60, 176, },
		[13] = { 62, 192, },
		[14] = { 64, 208, },
		[15] = { 65, 224, },
		[16] = { 66, 240, },
		[17] = { 67, 256, },
		[18] = { 68, 272, },
		[19] = { 69, 288, },
		[20] = { 70, 304, },
		[21] = { 72, 320, },
		[22] = { 74, 336, },
		[23] = { 76, 352, },
		[24] = { 78, 368, },
		[25] = { 80, 384, },
		[26] = { 82, 400, },
		[27] = { 84, 416, },
		[28] = { 86, 432, },
		[29] = { 88, 448, },
		[30] = { 90, 464, },
	},
}
skills["SupportChain"] = {
	name = "Chain",
	color = 2,
	support = true,
	requireSkillTypes = { 23, 3, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 50), 
		mod("ChainCountMax", "BASE", 2), --"number_of_additional_projectiles_in_chain" = 2
	},
	qualityMods = {
		mod("ProjectileSpeed", "INC", 1), --"base_projectile_speed_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil), --"support_chain_damage_+%_final"
	},
	levels = {
		[1] = { 38, -50, },
		[2] = { 40, -49, },
		[3] = { 42, -48, },
		[4] = { 44, -47, },
		[5] = { 46, -46, },
		[6] = { 48, -45, },
		[7] = { 50, -44, },
		[8] = { 52, -43, },
		[9] = { 54, -42, },
		[10] = { 56, -41, },
		[11] = { 58, -40, },
		[12] = { 60, -39, },
		[13] = { 62, -38, },
		[14] = { 64, -37, },
		[15] = { 65, -36, },
		[16] = { 66, -35, },
		[17] = { 67, -34, },
		[18] = { 68, -33, },
		[19] = { 69, -32, },
		[20] = { 70, -31, },
		[21] = { 72, -30, },
		[22] = { 74, -29, },
		[23] = { 76, -28, },
		[24] = { 78, -27, },
		[25] = { 80, -26, },
		[26] = { 82, -25, },
		[27] = { 84, -24, },
		[28] = { 86, -23, },
		[29] = { 88, -22, },
		[30] = { 90, -21, },
	},
}
skills["SupportChanceToFlee"] = {
	name = "Chance to Flee",
	color = 2,
	support = true,
	requireSkillTypes = { 1, 10, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
	},
	qualityMods = {
		--"global_hit_causes_monster_flee_%" = 1
	},
	levelMods = {
		[1] = nil, 
		--[2] = "global_hit_causes_monster_flee_%"
	},
	levels = {
		[1] = { 8, 25, },
		[2] = { 10, 26, },
		[3] = { 13, 27, },
		[4] = { 17, 28, },
		[5] = { 21, 29, },
		[6] = { 25, 30, },
		[7] = { 29, 31, },
		[8] = { 33, 32, },
		[9] = { 37, 33, },
		[10] = { 40, 34, },
		[11] = { 43, 35, },
		[12] = { 46, 36, },
		[13] = { 49, 37, },
		[14] = { 52, 38, },
		[15] = { 55, 39, },
		[16] = { 58, 40, },
		[17] = { 61, 41, },
		[18] = { 64, 42, },
		[19] = { 67, 43, },
		[20] = { 70, 44, },
		[21] = { 72, 45, },
		[22] = { 74, 46, },
		[23] = { 76, 47, },
		[24] = { 78, 48, },
		[25] = { 80, 49, },
		[26] = { 82, 50, },
		[27] = { 84, 51, },
		[28] = { 86, 52, },
		[29] = { 88, 53, },
		[30] = { 90, 54, },
	},
}
skills["SupportClusterTrap"] = {
	name = "Cluster Traps",
	color = 2,
	support = true,
	requireSkillTypes = { 37, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 50), 
		--"number_of_additional_traps_to_throw" = 3
		mod("ActiveTrapLimit", "BASE", 5), --"number_of_additional_traps_allowed" = 5
		--"throw_traps_in_circle_radius" = 20
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, 0, KeywordFlag.Trap), --"trap_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil), --"support_clustertrap_damage_+%_final"
	},
	levels = {
		[1] = { 38, -55, },
		[2] = { 40, -54, },
		[3] = { 42, -53, },
		[4] = { 44, -52, },
		[5] = { 46, -51, },
		[6] = { 48, -50, },
		[7] = { 50, -49, },
		[8] = { 52, -48, },
		[9] = { 54, -47, },
		[10] = { 56, -46, },
		[11] = { 58, -45, },
		[12] = { 60, -44, },
		[13] = { 62, -43, },
		[14] = { 64, -42, },
		[15] = { 65, -41, },
		[16] = { 66, -40, },
		[17] = { 67, -39, },
		[18] = { 68, -38, },
		[19] = { 69, -37, },
		[20] = { 70, -36, },
		[21] = { 72, -35, },
		[22] = { 74, -34, },
		[23] = { 76, -33, },
		[24] = { 78, -32, },
		[25] = { 80, -31, },
		[26] = { 82, -30, },
		[27] = { 84, -29, },
		[28] = { 86, -28, },
		[29] = { 88, -27, },
		[30] = { 90, -26, },
	},
}
skills["SupportColdPenetration"] = {
	name = "Cold Penetration",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
	},
	qualityMods = {
		mod("ColdDamage", "INC", 0.5), --"cold_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ColdPenetration", "BASE", nil), --"base_reduce_enemy_cold_resistance_%"
	},
	levels = {
		[1] = { 31, 18, },
		[2] = { 34, 19, },
		[3] = { 36, 20, },
		[4] = { 38, 21, },
		[5] = { 40, 22, },
		[6] = { 42, 23, },
		[7] = { 44, 24, },
		[8] = { 46, 25, },
		[9] = { 48, 26, },
		[10] = { 50, 27, },
		[11] = { 52, 28, },
		[12] = { 54, 29, },
		[13] = { 56, 30, },
		[14] = { 58, 31, },
		[15] = { 60, 32, },
		[16] = { 62, 33, },
		[17] = { 64, 34, },
		[18] = { 66, 35, },
		[19] = { 68, 36, },
		[20] = { 70, 37, },
		[21] = { 72, 38, },
		[22] = { 74, 39, },
		[23] = { 76, 40, },
		[24] = { 78, 41, },
		[25] = { 80, 42, },
		[26] = { 82, 43, },
		[27] = { 84, 44, },
		[28] = { 86, 45, },
		[29] = { 88, 46, },
		[30] = { 90, 47, },
	},
}
skills["SupportCullingStrike"] = {
	name = "Culling Strike",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
		--"kill_enemy_on_hit_if_under_10%_life" = 1
		mod("Speed", "INC", 0, ModFlag.Attack, 0, nil), --"attack_speed_+%" = 0
		mod("Speed", "INC", 0, ModFlag.Cast), --"base_cast_speed_+%" = 0
	},
	qualityMods = {
		mod("Speed", "INC", 0.5, ModFlag.Attack, 0, nil), --"attack_speed_+%" = 0.5
		mod("Speed", "INC", 0.5, ModFlag.Cast), --"base_cast_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "INC", nil, 0, 0, nil), --"damage_+%"
	},
	levels = {
		[1] = { 18, 0, },
		[2] = { 22, 2, },
		[3] = { 26, 4, },
		[4] = { 29, 6, },
		[5] = { 32, 8, },
		[6] = { 35, 10, },
		[7] = { 38, 12, },
		[8] = { 41, 14, },
		[9] = { 44, 16, },
		[10] = { 47, 18, },
		[11] = { 50, 20, },
		[12] = { 53, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportAdditionalQuality"] = {
	name = "Enhance",
	color = 2,
	support = true,
	requireSkillTypes = { },
	addSkillTypes = { },
	excludeSkillTypes = { },
	supportGemsOnly = true,
	baseMods = {
		mod("ManaCost", "MORE", 15), 
	},
	qualityMods = {
		--"local_gem_experience_gain_+%" = 5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("GemProperty", "LIST", { keyword = "active_skill", key = "quality", value = nil }), --"supported_active_skill_gem_quality_%"
	},
	levels = {
		[1] = { 1, 0, },
		[2] = { 10, 8, },
		[3] = { 45, 16, },
		[4] = { 60, 24, },
		[5] = { 75, 32, },
		[6] = { 90, 40, },
		[7] = { 100, 48, },
		[8] = { 100, 56, },
		[9] = { 100, 64, },
		[10] = { 100, 72, },
	},
}
skills["SupportFasterAttack"] = {
	name = "Faster Attacks",
	color = 2,
	support = true,
	requireSkillTypes = { 1, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 15), 
	},
	qualityMods = {
		mod("Speed", "INC", 0.5, ModFlag.Attack, 0, nil), --"attack_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Speed", "INC", nil, ModFlag.Attack, 0, nil), --"attack_speed_+%"
	},
	levels = {
		[1] = { 18, 25, },
		[2] = { 22, 26, },
		[3] = { 26, 27, },
		[4] = { 29, 28, },
		[5] = { 32, 29, },
		[6] = { 35, 30, },
		[7] = { 38, 31, },
		[8] = { 41, 32, },
		[9] = { 44, 33, },
		[10] = { 47, 34, },
		[11] = { 50, 35, },
		[12] = { 53, 36, },
		[13] = { 56, 37, },
		[14] = { 58, 38, },
		[15] = { 60, 39, },
		[16] = { 62, 40, },
		[17] = { 64, 41, },
		[18] = { 66, 42, },
		[19] = { 68, 43, },
		[20] = { 70, 44, },
		[21] = { 72, 45, },
		[22] = { 74, 46, },
		[23] = { 76, 47, },
		[24] = { 78, 48, },
		[25] = { 80, 49, },
		[26] = { 82, 50, },
		[27] = { 84, 51, },
		[28] = { 86, 52, },
		[29] = { 88, 53, },
		[30] = { 90, 54, },
	},
}
skills["SupportFasterProjectiles"] = {
	name = "Faster Projectiles",
	color = 2,
	support = true,
	requireSkillTypes = { 3, 14, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { 51, },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
	},
	qualityMods = {
		mod("Speed", "INC", 0.5, ModFlag.Attack, 0, nil), --"attack_speed_+%" = 0.5
		mod("Speed", "INC", 0.5, ModFlag.Cast), --"base_cast_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ProjectileSpeed", "INC", nil), --"base_projectile_speed_+%"
		[3] = mod("Damage", "INC", nil, ModFlag.Projectile), --"projectile_damage_+%"
	},
	levels = {
		[1] = { 31, 50, 20, },
		[2] = { 34, 51, 20, },
		[3] = { 36, 52, 21, },
		[4] = { 38, 53, 21, },
		[5] = { 40, 54, 22, },
		[6] = { 42, 55, 22, },
		[7] = { 44, 56, 23, },
		[8] = { 46, 57, 23, },
		[9] = { 48, 58, 24, },
		[10] = { 50, 59, 24, },
		[11] = { 52, 60, 25, },
		[12] = { 54, 61, 25, },
		[13] = { 56, 62, 26, },
		[14] = { 58, 63, 26, },
		[15] = { 60, 64, 27, },
		[16] = { 62, 65, 27, },
		[17] = { 64, 66, 28, },
		[18] = { 66, 67, 28, },
		[19] = { 68, 68, 29, },
		[20] = { 70, 69, 29, },
		[21] = { 72, 70, 30, },
		[22] = { 74, 71, 30, },
		[23] = { 76, 72, 31, },
		[24] = { 78, 73, 31, },
		[25] = { 80, 74, 32, },
		[26] = { 82, 75, 32, },
		[27] = { 84, 76, 33, },
		[28] = { 86, 77, 33, },
		[29] = { 88, 78, 34, },
		[30] = { 90, 79, 34, },
	},
}
skills["SupportFork"] = {
	name = "Fork",
	color = 2,
	support = true,
	requireSkillTypes = { 3, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 30), 
		--"projectiles_fork" = ?
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Projectile), --"projectile_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Projectile), --"support_fork_projectile_damage_+%_final"
	},
	levels = {
		[1] = { 31, -30, },
		[2] = { 34, -29, },
		[3] = { 36, -28, },
		[4] = { 38, -27, },
		[5] = { 40, -26, },
		[6] = { 42, -25, },
		[7] = { 44, -24, },
		[8] = { 46, -23, },
		[9] = { 48, -22, },
		[10] = { 50, -21, },
		[11] = { 52, -20, },
		[12] = { 54, -19, },
		[13] = { 56, -18, },
		[14] = { 58, -17, },
		[15] = { 60, -16, },
		[16] = { 62, -15, },
		[17] = { 64, -14, },
		[18] = { 66, -13, },
		[19] = { 68, -12, },
		[20] = { 70, -11, },
		[21] = { 72, -10, },
		[22] = { 74, -9, },
		[23] = { 76, -8, },
		[24] = { 78, -7, },
		[25] = { 80, -6, },
		[26] = { 82, -5, },
		[27] = { 84, -4, },
		[28] = { 86, -3, },
		[29] = { 88, -2, },
		[30] = { 90, -1, },
	},
}
skills["SupportGreaterMultipleProjectiles"] = {
	name = "Greater Multiple Projectiles",
	color = 2,
	support = true,
	requireSkillTypes = { 3, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 65), 
		mod("ProjectileCount", "BASE", 4), --"number_of_additional_projectiles" = 4
		mod("Damage", "INC", 0, ModFlag.Projectile), --"projectile_damage_+%" = 0
	},
	qualityMods = {
		mod("Speed", "INC", 0.5, ModFlag.Attack, 0, nil), --"attack_speed_+%" = 0.5
		mod("Speed", "INC", 0.5, ModFlag.Cast), --"base_cast_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Projectile), --"support_multiple_projectile_damage_+%_final"
	},
	levels = {
		[1] = { 38, -35, },
		[2] = { 40, -35, },
		[3] = { 42, -34, },
		[4] = { 44, -34, },
		[5] = { 46, -33, },
		[6] = { 48, -33, },
		[7] = { 50, -32, },
		[8] = { 52, -32, },
		[9] = { 54, -31, },
		[10] = { 56, -31, },
		[11] = { 58, -30, },
		[12] = { 60, -30, },
		[13] = { 62, -29, },
		[14] = { 64, -29, },
		[15] = { 65, -28, },
		[16] = { 66, -28, },
		[17] = { 67, -27, },
		[18] = { 68, -27, },
		[19] = { 69, -26, },
		[20] = { 70, -26, },
		[21] = { 72, -25, },
		[22] = { 74, -25, },
		[23] = { 76, -24, },
		[24] = { 78, -24, },
		[25] = { 80, -23, },
		[26] = { 82, -23, },
		[27] = { 84, -22, },
		[28] = { 86, -22, },
		[29] = { 88, -21, },
		[30] = { 90, -21, },
	},
}
skills["SupportDamageAgainstChilled"] = {
	name = "Hypothermia",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
		mod("EnemyFreezeChance", "BASE", 10, ModFlag.Hit, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }), --"additional_chance_to_freeze_chilled_enemies_%" = 10
	},
	qualityMods = {
		mod("EnemyChillDuration", "INC", 1.5), --"chill_duration_+%" = 1.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Hit, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }), --"support_hypothermia_damage_+%_vs_chilled_enemies_final"
	},
	levels = {
		[1] = { 31, 20, },
		[2] = { 34, 21, },
		[3] = { 36, 22, },
		[4] = { 38, 23, },
		[5] = { 40, 24, },
		[6] = { 42, 25, },
		[7] = { 44, 26, },
		[8] = { 46, 27, },
		[9] = { 48, 28, },
		[10] = { 50, 29, },
		[11] = { 52, 30, },
		[12] = { 54, 31, },
		[13] = { 56, 32, },
		[14] = { 58, 33, },
		[15] = { 60, 34, },
		[16] = { 62, 35, },
		[17] = { 64, 36, },
		[18] = { 66, 37, },
		[19] = { 68, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportFrenzyChargeOnSlayingFrozenEnemy"] = {
	name = "Ice Bite",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
		mod("EnemyFreezeChance", "BASE", 15), --"base_chance_to_freeze_%" = 15
	},
	qualityMods = {
		mod("Damage", "INC", 1, ModFlag.Hit, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }), --"damage_+%_vs_frozen_enemies" = 1
	},
	levelMods = {
		[1] = nil, 
		--[2] = "chance_to_gain_frenzy_charge_on_killing_frozen_enemy_%"
	},
	levels = {
		[1] = { 31, 50, },
		[2] = { 34, 51, },
		[3] = { 36, 52, },
		[4] = { 38, 53, },
		[5] = { 40, 54, },
		[6] = { 42, 55, },
		[7] = { 44, 56, },
		[8] = { 46, 57, },
		[9] = { 48, 58, },
		[10] = { 50, 59, },
		[11] = { 52, 60, },
		[12] = { 54, 61, },
		[13] = { 56, 62, },
		[14] = { 58, 63, },
		[15] = { 60, 64, },
		[16] = { 62, 65, },
		[17] = { 64, 66, },
		[18] = { 66, 67, },
		[19] = { 68, 68, },
		[20] = { 70, 69, },
		[21] = { 72, 70, },
		[22] = { 74, 71, },
		[23] = { 76, 72, },
		[24] = { 78, 73, },
		[25] = { 80, 74, },
		[26] = { 82, 75, },
		[27] = { 84, 76, },
		[28] = { 86, 77, },
		[29] = { 88, 78, },
		[30] = { 90, 79, },
	},
}
skills["SupportLesserMultipleProjectiles"] = {
	name = "Lesser Multiple Projectiles",
	color = 2,
	support = true,
	requireSkillTypes = { 3, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
		mod("ProjectileCount", "BASE", 2), --"number_of_additional_projectiles" = 2
		mod("Damage", "INC", 0, ModFlag.Projectile), --"projectile_damage_+%" = 0
	},
	qualityMods = {
		mod("Speed", "INC", 0.5, ModFlag.Attack, 0, nil), --"attack_speed_+%" = 0.5
		mod("Speed", "INC", 0.5, ModFlag.Cast), --"base_cast_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Projectile), --"support_lesser_multiple_projectile_damage_+%_final"
	},
	levels = {
		[1] = { 8, -25, },
		[2] = { 10, -25, },
		[3] = { 13, -24, },
		[4] = { 17, -24, },
		[5] = { 21, -23, },
		[6] = { 25, -23, },
		[7] = { 29, -22, },
		[8] = { 33, -22, },
		[9] = { 37, -21, },
		[10] = { 40, -21, },
		[11] = { 43, -20, },
		[12] = { 46, -20, },
		[13] = { 49, -19, },
		[14] = { 52, -19, },
		[15] = { 55, -18, },
		[16] = { 58, -18, },
		[17] = { 61, -17, },
		[18] = { 64, -17, },
		[19] = { 67, -16, },
		[20] = { 70, -16, },
		[21] = { 72, -15, },
		[22] = { 74, -15, },
		[23] = { 76, -14, },
		[24] = { 78, -14, },
		[25] = { 80, -13, },
		[26] = { 82, -13, },
		[27] = { 84, -12, },
		[28] = { 86, -12, },
		[29] = { 88, -11, },
		[30] = { 90, -11, },
	},
}
skills["SupportManaLeech"] = {
	name = "Mana Leech",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("DamageManaLeech", "BASE", 2), --"mana_leech_from_any_damage_permyriad" = 200
	},
	qualityMods = {
		mod("ManaLeechRate", "INC", 0.5), --"mana_leech_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ManaLeechRate", "INC", nil), --"mana_leech_speed_+%"
	},
	levels = {
		[1] = { 31, 0, },
		[2] = { 34, 2, },
		[3] = { 36, 4, },
		[4] = { 38, 6, },
		[5] = { 40, 8, },
		[6] = { 42, 10, },
		[7] = { 44, 12, },
		[8] = { 46, 14, },
		[9] = { 48, 16, },
		[10] = { 50, 18, },
		[11] = { 52, 20, },
		[12] = { 54, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportMultiTrap"] = {
	name = "Multiple Traps",
	color = 2,
	support = true,
	requireSkillTypes = { 37, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 60), 
		--"number_of_additional_traps_to_throw" = 2
		mod("ActiveTrapLimit", "BASE", 3), --"number_of_additional_traps_allowed" = 3
	},
	qualityMods = {
		mod("TrapTriggerAreaOfEffect", "INC", 1), --"trap_trigger_radius_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil), --"support_multithrow_damage_+%_final"
	},
	levels = {
		[1] = { 8, -40, },
		[2] = { 10, -39, },
		[3] = { 13, -38, },
		[4] = { 17, -37, },
		[5] = { 21, -36, },
		[6] = { 25, -35, },
		[7] = { 29, -34, },
		[8] = { 33, -33, },
		[9] = { 37, -32, },
		[10] = { 40, -31, },
		[11] = { 43, -30, },
		[12] = { 46, -29, },
		[13] = { 49, -28, },
		[14] = { 52, -27, },
		[15] = { 55, -26, },
		[16] = { 58, -25, },
		[17] = { 61, -24, },
		[18] = { 64, -23, },
		[19] = { 67, -22, },
		[20] = { 70, -21, },
		[21] = { 72, -20, },
		[22] = { 74, -19, },
		[23] = { 76, -18, },
		[24] = { 78, -17, },
		[25] = { 80, -16, },
		[26] = { 82, -15, },
		[27] = { 84, -14, },
		[28] = { 86, -13, },
		[29] = { 88, -12, },
		[30] = { 90, -11, },
	},
}
skills["SupportPhysicalProjectileAttackDamage"] = {
	name = "Physical Projectile Attack Damage",
	color = 2,
	support = true,
	requireSkillTypes = { 48, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
		mod("Speed", "MORE", -10, bit.bor(ModFlag.Attack, ModFlag.Projectile)), --"support_projectile_attack_speed_+%_final" = -10
	},
	qualityMods = {
		mod("PhysicalDamage", "INC", 0.5), --"physical_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("PhysicalDamage", "MORE", nil, bit.bor(ModFlag.Attack, ModFlag.Projectile)), --"support_projectile_attack_physical_damage_+%_final"
	},
	levels = {
		[1] = { 18, 30, },
		[2] = { 22, 31, },
		[3] = { 26, 32, },
		[4] = { 29, 33, },
		[5] = { 32, 34, },
		[6] = { 35, 35, },
		[7] = { 38, 36, },
		[8] = { 41, 37, },
		[9] = { 44, 38, },
		[10] = { 47, 39, },
		[11] = { 50, 40, },
		[12] = { 53, 41, },
		[13] = { 56, 42, },
		[14] = { 58, 43, },
		[15] = { 60, 44, },
		[16] = { 62, 45, },
		[17] = { 64, 46, },
		[18] = { 66, 47, },
		[19] = { 68, 48, },
		[20] = { 70, 49, },
		[21] = { 72, 50, },
		[22] = { 74, 51, },
		[23] = { 76, 52, },
		[24] = { 78, 53, },
		[25] = { 80, 54, },
		[26] = { 82, 55, },
		[27] = { 84, 56, },
		[28] = { 86, 57, },
		[29] = { 88, 58, },
		[30] = { 90, 59, },
	},
}
skills["SupportPierce"] = {
	name = "Pierce",
	color = 2,
	support = true,
	requireSkillTypes = { 3, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 30), 
		mod("PierceChance", "BASE", 50), --"pierce_%" = 50
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Projectile), --"projectile_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Projectile), --"support_pierce_projectile_damage_+%_final"
	},
	levels = {
		[1] = { 31, 10, },
		[2] = { 34, 10, },
		[3] = { 36, 11, },
		[4] = { 38, 11, },
		[5] = { 40, 12, },
		[6] = { 42, 12, },
		[7] = { 44, 13, },
		[8] = { 46, 13, },
		[9] = { 48, 14, },
		[10] = { 50, 14, },
		[11] = { 52, 15, },
		[12] = { 54, 15, },
		[13] = { 56, 16, },
		[14] = { 58, 16, },
		[15] = { 60, 17, },
		[16] = { 62, 17, },
		[17] = { 64, 18, },
		[18] = { 66, 18, },
		[19] = { 68, 19, },
		[20] = { 70, 19, },
		[21] = { 72, 20, },
		[22] = { 74, 20, },
		[23] = { 76, 21, },
		[24] = { 78, 21, },
		[25] = { 80, 22, },
		[26] = { 82, 22, },
		[27] = { 84, 23, },
		[28] = { 86, 23, },
		[29] = { 88, 24, },
		[30] = { 90, 24, },
	},
}
skills["SupportPointBlank"] = {
	name = "Point Blank",
	color = 2,
	support = true,
	requireSkillTypes = { 48, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
		flag("PointBlank"), --"keystone_point_blank" = 1
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Projectile), --"projectile_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "INC", nil, ModFlag.Projectile), --"projectile_damage_+%"
	},
	levels = {
		[1] = { 18, 0, },
		[2] = { 22, 2, },
		[3] = { 26, 4, },
		[4] = { 29, 6, },
		[5] = { 32, 8, },
		[6] = { 35, 10, },
		[7] = { 38, 12, },
		[8] = { 41, 14, },
		[9] = { 44, 16, },
		[10] = { 47, 18, },
		[11] = { 50, 20, },
		[12] = { 53, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportPoison"] = {
	name = "Poison",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 35), 
		mod("PoisonChance", "BASE", 100), --"global_poison_on_hit" = ?
	},
	qualityMods = {
		mod("Duration", "INC", 0.5, 0, KeywordFlag.Poison), --"base_poison_duration_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "INC", nil, 0, KeywordFlag.Poison), --"base_poison_damage_+%"
	},
	levels = {
		[1] = { 31, 0, },
		[2] = { 34, 2, },
		[3] = { 36, 4, },
		[4] = { 38, 6, },
		[5] = { 40, 8, },
		[6] = { 42, 10, },
		[7] = { 44, 12, },
		[8] = { 46, 14, },
		[9] = { 48, 16, },
		[10] = { 50, 18, },
		[11] = { 52, 20, },
		[12] = { 54, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportRapidDecay"] = {
	name = "Rapid Decay",
	color = 2,
	support = true,
	requireSkillTypes = { 12, 55, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 25), 
		mod("Duration", "INC", -15), --"skill_effect_duration_+%" = -15
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Dot), --"damage_over_time_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Dot), --"support_rapid_decay_damage_over_time_+%_final"
	},
	levels = {
		[1] = { 31, 20, },
		[2] = { 34, 21, },
		[3] = { 36, 22, },
		[4] = { 38, 23, },
		[5] = { 40, 24, },
		[6] = { 42, 25, },
		[7] = { 44, 26, },
		[8] = { 46, 27, },
		[9] = { 48, 28, },
		[10] = { 50, 29, },
		[11] = { 52, 30, },
		[12] = { 54, 31, },
		[13] = { 56, 32, },
		[14] = { 58, 33, },
		[15] = { 60, 34, },
		[16] = { 62, 35, },
		[17] = { 64, 36, },
		[18] = { 66, 37, },
		[19] = { 68, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportSlowerProjectiles"] = {
	name = "Slower Projectiles",
	color = 2,
	support = true,
	requireSkillTypes = { 3, 14, 54, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { 51, },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Projectile), --"projectile_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ProjectileSpeed", "MORE", nil), --"support_slower_projectiles_projectile_speed_+%_final"
		[3] = mod("Damage", "MORE", nil, ModFlag.Projectile), --"support_slower_projectiles_damage_+%_final"
	},
	levels = {
		[1] = { 31, -30, 20, },
		[2] = { 34, -31, 20, },
		[3] = { 36, -32, 21, },
		[4] = { 38, -33, 21, },
		[5] = { 40, -34, 22, },
		[6] = { 42, -35, 22, },
		[7] = { 44, -36, 23, },
		[8] = { 46, -37, 23, },
		[9] = { 48, -38, 24, },
		[10] = { 50, -39, 24, },
		[11] = { 52, -40, 25, },
		[12] = { 54, -41, 25, },
		[13] = { 56, -42, 26, },
		[14] = { 58, -43, 26, },
		[15] = { 60, -44, 27, },
		[16] = { 62, -45, 27, },
		[17] = { 64, -46, 28, },
		[18] = { 66, -47, 28, },
		[19] = { 68, -48, 29, },
		[20] = { 70, -49, 29, },
		[21] = { 72, -50, 30, },
		[22] = { 74, -51, 30, },
		[23] = { 76, -52, 31, },
		[24] = { 78, -53, 31, },
		[25] = { 80, -54, 32, },
		[26] = { 82, -55, 32, },
		[27] = { 84, -56, 33, },
		[28] = { 86, -57, 33, },
		[29] = { 88, -58, 34, },
		[30] = { 90, -59, 34, },
	},
}
skills["SupportTrap"] = {
	name = "Trap",
	color = 2,
	support = true,
	requireSkillTypes = { 17, },
	addSkillTypes = { 12, 37, },
	excludeSkillTypes = { 61, },
	addFlags = {
		trap = true,
		duration = true,
	},
	baseMods = {
		mod("ManaCost", "MORE", 40), 
		skill("cooldown", 4), 
		--"is_trap" = 1
		--"base_trap_duration" = 16000
		--"trap_override_pvp_scaling_time_ms" = 900
		--"base_skill_is_trapped" = ?
		--"disable_skill_if_melee_attack" = ?
		skill("showAverage", true, { type = "SkillType", skillType = SkillType.SkillCanTrap }), --"base_skill_show_average_damage_instead_of_dps" = ?
		skill("trapCooldown", 4), 
	},
	qualityMods = {
		mod("TrapThrowingSpeed", "INC", 0.5), --"trap_throwing_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Hit, KeywordFlag.Trap), --"support_trap_hit_damage_+%_final"
	},
	levels = {
		[1] = { 8, 20, },
		[2] = { 10, 21, },
		[3] = { 13, 22, },
		[4] = { 17, 23, },
		[5] = { 21, 24, },
		[6] = { 25, 25, },
		[7] = { 29, 26, },
		[8] = { 33, 27, },
		[9] = { 37, 28, },
		[10] = { 40, 29, },
		[11] = { 43, 30, },
		[12] = { 46, 31, },
		[13] = { 49, 32, },
		[14] = { 52, 33, },
		[15] = { 55, 34, },
		[16] = { 58, 35, },
		[17] = { 61, 36, },
		[18] = { 64, 37, },
		[19] = { 67, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportTrapCooldown"] = {
	name = "Trap Cooldown",
	color = 2,
	support = true,
	requireSkillTypes = { 37, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, 0, KeywordFlag.Trap), --"trap_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("CooldownRecovery", "INC", nil, 0, KeywordFlag.Trap), --"placing_traps_cooldown_recovery_+%"
	},
	levels = {
		[1] = { 31, 30, },
		[2] = { 34, 31, },
		[3] = { 36, 32, },
		[4] = { 38, 33, },
		[5] = { 40, 34, },
		[6] = { 42, 35, },
		[7] = { 44, 36, },
		[8] = { 46, 37, },
		[9] = { 48, 38, },
		[10] = { 50, 39, },
		[11] = { 52, 40, },
		[12] = { 54, 41, },
		[13] = { 56, 42, },
		[14] = { 58, 43, },
		[15] = { 60, 44, },
		[16] = { 62, 45, },
		[17] = { 64, 46, },
		[18] = { 66, 47, },
		[19] = { 68, 48, },
		[20] = { 70, 49, },
		[21] = { 72, 50, },
		[22] = { 74, 51, },
		[23] = { 76, 52, },
		[24] = { 78, 53, },
		[25] = { 80, 54, },
		[26] = { 82, 55, },
		[27] = { 84, 56, },
		[28] = { 86, 57, },
		[29] = { 88, 58, },
		[30] = { 90, 59, },
	},
}
skills["SupportTrapAndMineDamage"] = {
	name = "Trap and Mine Damage",
	color = 2,
	support = true,
	requireSkillTypes = { 37, 41, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 30), 
		mod("TrapThrowingSpeed", "INC", -10), --"trap_throwing_speed_+%" = -10
		mod("MineLayingSpeed", "INC", -10), --"mine_laying_speed_+%" = -10
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, 0, 0, nil), --"damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Trap, KeywordFlag.Mine)), --"support_trap_and_mine_damage_+%_final"
	},
	levels = {
		[1] = { 18, 20, },
		[2] = { 22, 21, },
		[3] = { 26, 22, },
		[4] = { 29, 23, },
		[5] = { 32, 24, },
		[6] = { 35, 25, },
		[7] = { 38, 26, },
		[8] = { 41, 27, },
		[9] = { 44, 28, },
		[10] = { 47, 29, },
		[11] = { 50, 30, },
		[12] = { 53, 31, },
		[13] = { 56, 32, },
		[14] = { 58, 33, },
		[15] = { 60, 34, },
		[16] = { 62, 35, },
		[17] = { 64, 36, },
		[18] = { 66, 37, },
		[19] = { 68, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportVoidManipulation"] = {
	name = "Void Manipulation",
	color = 2,
	support = true,
	requireSkillTypes = { 10, 1, 40, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
		mod("ElementalDamage", "INC", -25), --"elemental_damage_+%" = -25
	},
	qualityMods = {
		mod("ChaosDamage", "INC", 0.5), --"chaos_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ChaosDamage", "MORE", nil), --"support_void_manipulation_chaos_damage_+%_final"
	},
	levels = {
		[1] = { 8, 20, },
		[2] = { 10, 21, },
		[3] = { 13, 22, },
		[4] = { 17, 23, },
		[5] = { 21, 24, },
		[6] = { 25, 25, },
		[7] = { 29, 26, },
		[8] = { 33, 27, },
		[9] = { 37, 28, },
		[10] = { 40, 29, },
		[11] = { 43, 30, },
		[12] = { 46, 31, },
		[13] = { 49, 32, },
		[14] = { 52, 33, },
		[15] = { 55, 34, },
		[16] = { 58, 35, },
		[17] = { 61, 36, },
		[18] = { 64, 37, },
		[19] = { 67, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}